window.onload = function () {
  var listItems = document.querySelectorAll(".anchor li");
  for (var i = 0; i < listItems.length; i++) {
    listItems[i].addEventListener("click", function (e) {
      e.preventDefault();
      var anchor = e.target.getAttribute("data-anchor");
      window.scroll({
        behavior: "smooth",
        left: 0,
        top: document.querySelector(anchor).offsetTop - 20,
      });
    });
  }

  document
    .querySelector(".custom-selectbox__btn")
    .addEventListener("click", function () {
      document.querySelector(".custom-selectbox").classList.toggle("active");
    });

  onClickOutside(document.querySelector(".custom-selectbox"), function () {
    document.querySelector(".custom-selectbox").classList.remove("active");
  });

  function onClickOutside($box, callback) {
    document.body.addEventListener("click", function (e) {
      if (!isEventTargetInWidget(e.target, $box)) {
        callback();
      }
    });
  }

  function isEventTargetInWidget(target, $box) {
    return $box === target || $box.contains(target);
  }
};
